package com.wissamfawaz;

import java.math.BigInteger;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        int n;
        Scanner scan = new Scanner(System.in);

        System.out.println("Enter n (-1 to quit): ");
        n = scan.nextInt();

        while (n != -1) {

            System.out.println("Iterative solution: " + factIter(n));
            System.out.println("Recursive solution: " + factRec(n));
            System.out.println("Accurate solution: " + factAcc(n));

            System.out.println("Enter n (-1 to quit): ");
            n = scan.nextInt();
        }

        scan.close();
    }

    private static long factIter(int n) {
        long result = 1L;

        for (int i = 1; i <= n; i++) {
            result *= i;
        }

        return result;
    }

    private static long factRec(int n) {
        if (n == 0)
            return 1;
        return n * factRec(n - 1);
    }

    private static BigInteger factAcc(int n) {
        BigInteger result = BigInteger.ONE;

        for (int i = 1; i <= n; i++) {
            result = result.multiply(BigInteger.valueOf(i));
        }

        return result;
    }
}
